/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.graphics.font;

import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.font.FontMetricsInt;
import icyllis.modernui.graphics.font.TexturedGlyph;
import icyllis.modernui.graphics.textmc.pipeline.TextRenderType;
import icyllis.modernui.graphics.texture.Texture2D;
import icyllis.modernui.platform.RenderCore;
import icyllis.modernui.text.FontCollection;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMaps;
import it.unimi.dsi.fastutil.longs.Long2ObjectRBTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.GlyphVector;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.resources.IResource;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryUtil;

public class GlyphManager {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Font");
    private static GlyphManager instance;
    public static String sPreferredFont;
    public static boolean sAntiAliasing;
    public static boolean sHighPrecision;
    public static boolean sEnableMipmap;
    public static int sMipmapLevel;
    public static int sResolutionLevel;
    @Deprecated
    private static final int TEXTURE_WIDTH = 256;
    @Deprecated
    private static final int TEXTURE_HEIGHT = 256;
    public static final int TEXTURE_SIZE = 1024;
    @Deprecated
    private static final int STRING_WIDTH = 256;
    @Deprecated
    private static final int STRING_HEIGHT = 64;
    private static final int GLYPH_BORDER = 2;
    private static final int GLYPH_SPACING = 3;
    public static final float GLYPH_OFFSET = 1.0f;
    private static final Color BG_COLOR;
    @Deprecated
    private BufferedImage tempStringImage;
    @Deprecated
    private Graphics2D tempStringGraphics;
    private final BufferedImage mGlyphImage = new BufferedImage(1024, 1024, 2);
    private final Graphics2D mGlyphGraphics = this.mGlyphImage.createGraphics();
    private final int[] mImageData = new int[8192];
    private final ByteBuffer mUploadBuffer = BufferUtils.createByteBuffer((int)this.mImageData.length);
    private final long mDataPtr = MemoryUtil.memAddress((ByteBuffer)this.mUploadBuffer);
    private final List<Font> mSelectedFonts = new ObjectArrayList();
    private Texture2D mTexture;
    private final Object2IntMap<Font> mFontKeyMap = new Object2IntOpenHashMap();
    private final Long2ObjectMap<TexturedGlyph> mGlyphCache = Long2ObjectMaps.synchronize((Long2ObjectMap)new Long2ObjectRBTreeMap());
    private final Int2ObjectMap<TexturedGlyph[]> mDigitsMap = new Int2ObjectArrayMap(4);
    private final Int2ObjectMap<TexturedGlyph> mEmojiMap = new Int2ObjectArrayMap(32);
    @Deprecated
    private int emojiTexture;
    private int mCurrPosX = 3;
    private int mCurrPosY = 3;
    private int mCurrLineHeight = 0;

    private GlyphManager() {
        instance = this;
        this.mGlyphGraphics.setBackground(BG_COLOR);
        this.mGlyphGraphics.setComposite(AlphaComposite.Src);
        this.allocateGlyphTexture();
        this.loadPreferredFonts();
        this.setRenderingHints();
    }

    @Nonnull
    public static GlyphManager getInstance() {
        RenderCore.ensureRenderThread();
        if (instance == null) {
            new GlyphManager();
        }
        return instance;
    }

    public void reload() {
        this.mCurrPosX = 3;
        this.mCurrPosY = 3;
        this.mCurrLineHeight = 0;
        this.mFontKeyMap.clear();
        this.mGlyphCache.clear();
        this.mDigitsMap.clear();
        this.mEmojiMap.clear();
        this.mTexture = null;
        this.emojiTexture = 0;
        TextRenderType.deleteTextures();
        this.mSelectedFonts.clear();
        this.allocateGlyphTexture();
        this.loadPreferredFonts();
        this.setRenderingHints();
        ModernUI.LOGGER.debug(MARKER, "Font engine reloaded");
    }

    private void loadPreferredFonts() {
        if (StringUtils.isNotEmpty((CharSequence)sPreferredFont)) {
            String cfgFont = sPreferredFont;
            if (cfgFont.endsWith(".ttf") || cfgFont.endsWith(".otf") || cfgFont.endsWith(".TTF") || cfgFont.endsWith(".OTF")) {
                if (cfgFont.contains(":/") || cfgFont.contains(":\\")) {
                    if (!FontCollection.sJavaTooOld) {
                        try {
                            Font f2 = Font.createFont(0, new File(cfgFont.replaceAll("\\\\", "/")));
                            this.mSelectedFonts.add(f2);
                            ModernUI.LOGGER.debug(MARKER, "Preferred font {} was loaded", (Object)f2.getFamily(Locale.ROOT));
                        }
                        catch (Exception e) {
                            ModernUI.LOGGER.warn(MARKER, "Preferred font {} failed to load", (Object)cfgFont, (Object)e);
                        }
                    } else {
                        ModernUI.LOGGER.warn(MARKER, "Cannot load external font {} since Java is too old", (Object)cfgFont);
                    }
                } else if (cfgFont.contains(":")) {
                    if (!FontCollection.sJavaTooOld) {
                        try (IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(cfgFont));){
                            Font f3 = Font.createFont(0, resource.func_199027_b());
                            this.mSelectedFonts.add(f3);
                            ModernUI.LOGGER.debug(MARKER, "Preferred font {} was loaded", (Object)f3.getFamily(Locale.ROOT));
                        }
                        catch (Exception e) {
                            ModernUI.LOGGER.warn(MARKER, "Preferred font {} failed to load", (Object)cfgFont, (Object)e);
                        }
                    } else {
                        ModernUI.LOGGER.warn(MARKER, "Cannot load resource pack font {} since Java is too old", (Object)cfgFont);
                    }
                } else {
                    ModernUI.LOGGER.warn(MARKER, "Preferred font {} is invalid", (Object)cfgFont);
                }
            } else {
                Optional<Font> font = FontCollection.sAllFontFamilies.stream().filter(f -> f.getFamily(Locale.ROOT).equals(cfgFont)).findFirst();
                if (font.isPresent()) {
                    this.mSelectedFonts.add(font.get());
                    ModernUI.LOGGER.debug(MARKER, "Preferred font {} was loaded", (Object)cfgFont);
                } else {
                    ModernUI.LOGGER.warn(MARKER, "Preferred font {} cannot found or invalid", (Object)cfgFont);
                }
            }
        }
        if (FontCollection.sBuiltInFont != null) {
            this.mSelectedFonts.add(FontCollection.sBuiltInFont);
        }
        this.mSelectedFonts.add(FontCollection.sSansSerifFont);
    }

    public GlyphVector layoutGlyphVector(@Nonnull Font font, char[] text, int start, int limit, int layoutFlags) {
        return font.layoutGlyphVector(this.mGlyphGraphics.getFontRenderContext(), text, start, limit, layoutFlags);
    }

    @Nonnull
    public Font lookupFont(int codePoint) {
        for (Font font : this.mSelectedFonts) {
            if (!font.canDisplay(codePoint)) continue;
            return font;
        }
        for (Font font : FontCollection.sAllFontFamilies) {
            if (!font.canDisplay(codePoint)) continue;
            this.mSelectedFonts.add(font);
            ModernUI.LOGGER.debug(MARKER, "Extra font {} was loaded", (Object)font.getFamily(Locale.ROOT));
            return font;
        }
        return this.mSelectedFonts.get(0);
    }

    public void getFontMetrics(@Nonnull FontCollection font, int style, int size, @Nonnull FontMetricsInt fm) {
        fm.reset();
        for (Font family : font.getFonts()) {
            fm.extendBy(this.mGlyphGraphics.getFontMetrics(family.deriveFont(style, size)));
        }
    }

    public void getFontMetrics(@Nonnull Font derivedFont, @Nonnull FontMetricsInt fm) {
        fm.extendBy(this.mGlyphGraphics.getFontMetrics(derivedFont));
    }

    @Deprecated
    public TexturedGlyph lookupEmoji(int codePoint) {
        return (TexturedGlyph)this.mEmojiMap.computeIfAbsent(codePoint, l -> {
            if (this.emojiTexture == 0) {
                ResourceLocation resourceLocation = new ResourceLocation("modernui", "textures/gui/emoji.png");
                SimpleTexture texture = new SimpleTexture(resourceLocation);
                Minecraft.func_71410_x().func_110434_K().func_229263_a_(resourceLocation, (Texture)texture);
                this.emojiTexture = texture.func_110552_b();
            }
            return new TexturedGlyph(this.emojiTexture, 12.0f, 0.0f, -8.0f, 12.0f, 12.0f, 0.0f, 0.0f, 0.046875f, 0.046875f);
        });
    }

    @Nonnull
    public Font deriveFont(@Nonnull Font family, int style, int size) {
        family = family.deriveFont(style, size);
        this.mFontKeyMap.putIfAbsent((Object)family, this.mFontKeyMap.size());
        return family;
    }

    public float getResolutionFactor() {
        return (float)sResolutionLevel * 2.0f;
    }

    @Nonnull
    @Deprecated
    private Font lookupFont(int codePoint, int fontStyle, int fontSize) {
        for (Font font : this.mSelectedFonts) {
            if (!font.canDisplay(codePoint)) continue;
            return font.deriveFont(fontStyle, fontSize);
        }
        for (Font font : FontCollection.sAllFontFamilies) {
            if (!font.canDisplay(codePoint)) continue;
            this.mSelectedFonts.add(font);
            ModernUI.LOGGER.debug(MARKER, "Extra font {} was loaded", (Object)font.getName());
            return font.deriveFont(fontStyle, fontSize);
        }
        Font font = this.mSelectedFonts.get(0);
        return font.deriveFont(fontStyle, fontSize);
    }

    @Nonnull
    public TexturedGlyph lookupGlyph(Font font, int glyphCode) {
        long fontKey = (long)this.mFontKeyMap.getInt((Object)font) << 32;
        return (TexturedGlyph)this.mGlyphCache.computeIfAbsent(fontKey | (long)glyphCode, iLoveSukazyo -> this.cacheGlyph(font, glyphCode));
    }

    @Nonnull
    @Deprecated
    private TexturedGlyph lookupGlyph(int codePoint, int fontStyle, int fontSize) {
        return this.lookupGlyph(this.lookupFont(codePoint, fontStyle, fontSize), codePoint);
    }

    @Nonnull
    private TexturedGlyph cacheGlyph(@Nonnull Font font, int glyphCode) {
        GlyphVector vector = font.createGlyphVector(this.mGlyphGraphics.getFontRenderContext(), new int[]{glyphCode});
        Rectangle renderBounds = vector.getGlyphPixelBounds(0, this.mGlyphGraphics.getFontRenderContext(), 0.0f, 0.0f);
        int renderWidth = (int)renderBounds.getWidth();
        int renderHeight = (int)renderBounds.getHeight();
        if (this.mCurrPosX + renderWidth + 3 >= 1024) {
            this.mCurrPosX = 3;
            this.mCurrPosY += this.mCurrLineHeight + 6;
            this.mCurrLineHeight = 0;
        }
        if (this.mCurrPosY + renderHeight + 3 >= 1024) {
            this.mCurrPosX = 3;
            this.mCurrPosY = 3;
            this.allocateGlyphTexture();
        }
        int baselineX = (int)renderBounds.getX();
        int baselineY = (int)renderBounds.getY();
        float advance = vector.getGlyphMetrics(0).getAdvanceX();
        this.mGlyphGraphics.setFont(font);
        int x = this.mCurrPosX - 2;
        int y = this.mCurrPosY - 2;
        int width = renderWidth + 4;
        int height = renderHeight + 4;
        this.mGlyphGraphics.drawGlyphVector(vector, this.mCurrPosX - baselineX, this.mCurrPosY - baselineY);
        this.uploadTexture(x, y, width, height);
        this.mCurrLineHeight = Math.max(this.mCurrLineHeight, renderHeight);
        this.mCurrPosX += renderWidth + 6;
        float f = this.getResolutionFactor();
        return new TexturedGlyph(this.mTexture.getId(), advance / f, (float)baselineX / f, (float)baselineY / f, (float)width / f, (float)height / f, (float)x / 1024.0f, (float)y / 1024.0f, (float)(x + width) / 1024.0f, (float)(y + height) / 1024.0f);
    }

    public TexturedGlyph[] lookupDigits(Font font) {
        int fontKey = this.mFontKeyMap.getInt((Object)font);
        return (TexturedGlyph[])this.mDigitsMap.computeIfAbsent(fontKey, l -> this.cacheDigits(font));
    }

    @Deprecated
    private TexturedGlyph[] lookupDigits(int fontStyle, int fontSize) {
        return this.lookupDigits(this.lookupFont(48, fontStyle, fontSize));
    }

    @Nonnull
    private TexturedGlyph[] cacheDigits(@Nonnull Font font) {
        TexturedGlyph[] digits = new TexturedGlyph[10];
        char[] chars = new char[1];
        this.mGlyphGraphics.setFont(font);
        float standardAdvance = 0.0f;
        int standardRenderWidth = 0;
        float f = this.getResolutionFactor();
        for (int i = 0; i < 10; ++i) {
            chars[0] = (char)(48 + i);
            GlyphVector vector = font.createGlyphVector(this.mGlyphGraphics.getFontRenderContext(), chars);
            Rectangle renderBounds = vector.getGlyphPixelBounds(0, this.mGlyphGraphics.getFontRenderContext(), 0.0f, 0.0f);
            int renderWidth = (int)renderBounds.getWidth();
            int renderHeight = (int)renderBounds.getHeight();
            if (i == 0) {
                if (this.mCurrPosX + renderWidth + 3 >= 1024) {
                    this.mCurrPosX = 3;
                    this.mCurrPosY += this.mCurrLineHeight + 6;
                    this.mCurrLineHeight = 0;
                }
            } else if (this.mCurrPosX + standardRenderWidth + 3 >= 1024) {
                this.mCurrPosX = 3;
                this.mCurrPosY += this.mCurrLineHeight + 6;
                this.mCurrLineHeight = 0;
            }
            if (this.mCurrPosY + renderHeight + 3 >= 1024) {
                this.mCurrPosX = 3;
                this.mCurrPosY = 3;
                this.allocateGlyphTexture();
            }
            int baselineX = (int)renderBounds.getX();
            int baselineY = (int)renderBounds.getY();
            if (i == 0) {
                standardAdvance = vector.getGlyphMetrics(0).getAdvanceX();
                standardRenderWidth = renderWidth;
            }
            int x = this.mCurrPosX - 2;
            int y = this.mCurrPosY - 2;
            int width = i == 0 ? renderWidth + 4 : standardRenderWidth + 4;
            int height = renderHeight + 4;
            if (i == 0) {
                this.mGlyphGraphics.drawString(String.valueOf(chars), this.mCurrPosX - baselineX, this.mCurrPosY - baselineY);
            } else {
                int offset = Math.round((standardAdvance - vector.getGlyphMetrics(0).getAdvanceX()) / 2.0f);
                this.mGlyphGraphics.drawString(String.valueOf(chars), this.mCurrPosX + offset - baselineX, this.mCurrPosY - baselineY);
            }
            this.uploadTexture(x, y, width, height);
            this.mCurrLineHeight = Math.max(this.mCurrLineHeight, renderHeight);
            this.mCurrPosX += standardRenderWidth + 6;
            digits[i] = new TexturedGlyph(this.mTexture.getId(), standardAdvance / f, (float)baselineX / f, (float)baselineY / f, (float)width / f, (float)height / f, (float)x / 1024.0f, (float)y / 1024.0f, (float)(x + width) / 1024.0f, (float)(y + height) / 1024.0f);
        }
        return digits;
    }

    @Deprecated
    private void cacheGlyphs(Font font, char[] text, int start, int limit, int layoutFlags) {
        GlyphVector vector = this.layoutGlyphVector(font, text, start, limit, layoutFlags);
        Rectangle vectorBounds = null;
        long fontKey = (long)this.mFontKeyMap.get((Object)font).intValue() << 32;
        int numGlyphs = vector.getNumGlyphs();
        Rectangle dirty = null;
        boolean vectorRendered = false;
        for (int index = 0; index < numGlyphs; ++index) {
            int glyphCode = vector.getGlyphCode(index);
            if (this.mGlyphCache.containsKey(fontKey | (long)glyphCode)) continue;
            if (!vectorRendered) {
                vectorRendered = true;
                for (int i = 0; i < numGlyphs; ++i) {
                    Point2D pos = vector.getGlyphPosition(i);
                    pos.setLocation(pos.getX() + (double)(2 * i), pos.getY());
                    vector.setGlyphPosition(i, pos);
                }
                vectorBounds = vector.getPixelBounds(this.mGlyphGraphics.getFontRenderContext(), 0.0f, 0.0f);
                if (vectorBounds.width > this.tempStringImage.getWidth() || vectorBounds.height > this.tempStringImage.getHeight()) {
                    int width = Math.max(vectorBounds.width, this.tempStringImage.getWidth());
                    int height = Math.max(vectorBounds.height, this.tempStringImage.getHeight());
                    this.allocateStringImage(width, height);
                }
                this.tempStringGraphics.clearRect(0, 0, vectorBounds.width, vectorBounds.height);
                this.tempStringGraphics.drawGlyphVector(vector, -vectorBounds.x, -vectorBounds.y);
            }
            Rectangle rect = vector.getGlyphPixelBounds(index, null, -vectorBounds.x, -vectorBounds.y);
            if (this.mCurrPosX + rect.width + 3 > 256) {
                this.mCurrPosX = 3;
                this.mCurrPosY += this.mCurrLineHeight + 3;
                this.mCurrLineHeight = 0;
            }
            if (this.mCurrPosY + rect.height + 3 > 256) {
                this.updateTexture(dirty);
                this.allocateGlyphTexture();
                this.allocateStringImage(256, 64);
                this.mCurrPosX = 3;
                this.mCurrPosY = 3;
                this.mCurrLineHeight = 0;
                this.cacheGlyphs(font, text, start + index, limit, layoutFlags);
                return;
            }
            if (rect.height > this.mCurrLineHeight) {
                this.mCurrLineHeight = rect.height;
            }
            this.mGlyphGraphics.drawImage(this.tempStringImage, this.mCurrPosX, this.mCurrPosY, this.mCurrPosX + rect.width, this.mCurrPosY + rect.height, rect.x, rect.y, rect.x + rect.width, rect.y + rect.height, null);
            rect.setLocation(this.mCurrPosX, this.mCurrPosY);
            if (dirty == null) {
                dirty = new Rectangle(this.mCurrPosX, this.mCurrPosY, rect.width, rect.height);
            } else {
                dirty.add(rect);
            }
            this.mCurrPosX += rect.width + 3;
        }
        this.updateTexture(dirty);
    }

    @Deprecated
    private void updateTexture(@Nullable Rectangle dirty) {
    }

    private void uploadTexture(int x, int y, int width, int height) {
        this.updateImageBuffer(x, y, width, height);
        this.mTexture.upload(0, x, y, width, height, width, 0, 0, 1, 6406, 5121, this.mDataPtr);
        if (sEnableMipmap && sMipmapLevel > 0) {
            this.mTexture.generateMipmap();
        }
    }

    private void updateImageBuffer(int x, int y, int width, int height) {
        this.mGlyphImage.getRGB(x, y, width, height, this.mImageData, 0, width);
        this.mUploadBuffer.clear();
        int size = width * height;
        for (int i = 0; i < size; ++i) {
            this.mUploadBuffer.put((byte)(this.mImageData[i] >>> 24));
        }
        this.mUploadBuffer.flip();
    }

    private void setRenderingHints() {
        this.mGlyphGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (sAntiAliasing) {
            this.mGlyphGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            this.mGlyphGraphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (sHighPrecision) {
            this.mGlyphGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        } else {
            this.mGlyphGraphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        }
    }

    private void allocateGlyphTexture() {
        this.mGlyphGraphics.clearRect(0, 0, 1024, 1024);
        this.mTexture = new Texture2D();
        int mipmapLevel = sEnableMipmap ? sMipmapLevel : 0;
        this.mTexture.init(6406, 1024, 1024, mipmapLevel);
        this.mTexture.setFilter(sAntiAliasing, sEnableMipmap);
        int size = 256;
        for (int i = 0; i < 256; ++i) {
            int x = (i & 0xF) << 6;
            int y = i / 16 << 6;
            this.uploadTexture(x, y, 64, 64);
        }
    }

    @Deprecated
    private void allocateStringImage(int width, int height) {
    }

    static {
        BG_COLOR = new Color(0, 0, 0, 0);
    }
}

